(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require Reals.R_sqrt.
Require Reals.Rbasic_fun.
Require BuiltIn.
Require int.Int.
Require int.Abs.
Require int.ComputerDivision.
Require bool.Bool.
Require real.Real.
Require real.RealInfix.
Require real.Abs.
Require real.FromInt.
Require real.Square.
Require floating_point.Rounding.
Require floating_point.SingleFormat.
Require floating_point.DoubleFormat.
Require floating_point.Single.
Require floating_point.Double.
Require Jessie_memory_model.

(* Why3 assumption *)
Definition unit := unit.

Axiom qtmark : Type.
Parameter qtmark_WhyType : WhyType qtmark.
Existing Instance qtmark_WhyType.

Axiom charP : Type.
Parameter charP_WhyType : WhyType charP.
Existing Instance charP_WhyType.

Axiom int8 : Type.
Parameter int8_WhyType : WhyType int8.
Existing Instance int8_WhyType.

Axiom padding : Type.
Parameter padding_WhyType : WhyType padding.
Existing Instance padding_WhyType.

Axiom uint8 : Type.
Parameter uint8_WhyType : WhyType uint8.
Existing Instance uint8_WhyType.

Axiom unsigned_charP : Type.
Parameter unsigned_charP_WhyType : WhyType unsigned_charP.
Existing Instance unsigned_charP_WhyType.

Axiom voidP : Type.
Parameter voidP_WhyType : WhyType voidP.
Existing Instance voidP_WhyType.

Parameter charP_tag: (Jessie_memory_model.tag_id charP).

Axiom charP_int : ((Jessie_memory_model.int_of_tag charP_tag) = 1%Z).

Parameter charP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer charP).

Axiom charP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  charP)),
  (p = (charP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom charP_parenttag_bottom : (Jessie_memory_model.parenttag charP_tag
  (Jessie_memory_model.bottom_tag : (Jessie_memory_model.tag_id charP))).

Axiom charP_tags : forall (x:(Jessie_memory_model.pointer charP)),
  forall (charP_tag_table:(Jessie_memory_model.tag_table charP)),
  (Jessie_memory_model.instanceof charP_tag_table x charP_tag).

(* Why3 assumption *)
Definition closeness (u:R) (t_1:R) (x_1:R): Prop :=
  ((Reals.Rbasic_fun.Rabs (u - (((05 / 10)%R * t_1)%R * (3%R - ((t_1 * t_1)%R * x_1)%R)%R)%R)%R) <= 1%R)%R /\
  ((Reals.Rbasic_fun.Rabs (u - (1%R / (Reals.R_sqrt.sqrt x_1))%R)%R) <= 1%R)%R.

Parameter integer_of_int8: int8 -> Z.

(* Why3 assumption *)
Definition eq_int8 (x:int8) (y:int8): Prop :=
  ((integer_of_int8 x) = (integer_of_int8 y)).

Parameter integer_of_uint8: uint8 -> Z.

(* Why3 assumption *)
Definition eq_uint8 (x:uint8) (y:uint8): Prop :=
  ((integer_of_uint8 x) = (integer_of_uint8 y)).

Parameter int8_of_integer: Z -> int8.

Axiom int8_coerce : forall (x:Z), (((-128%Z)%Z <= x)%Z /\ (x <= 127%Z)%Z) ->
  ((integer_of_int8 (int8_of_integer x)) = x).

Axiom int8_extensionality : forall (x:int8), forall (y:int8),
  ((integer_of_int8 x) = (integer_of_int8 y)) -> (x = y).

Axiom int8_range : forall (x:int8), ((-128%Z)%Z <= (integer_of_int8 x))%Z /\
  ((integer_of_int8 x) <= 127%Z)%Z.

(* Why3 assumption *)
Definition left_valid_struct_charP (p:(Jessie_memory_model.pointer charP))
  (a:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z.

(* Why3 assumption *)
Definition left_valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) <= a)%Z.

(* Why3 assumption *)
Definition left_valid_struct_voidP (p:(Jessie_memory_model.pointer voidP))
  (a:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z.

(* Why3 assumption *)
Definition newton_rel (t:R) (x_0:R): Prop :=
  ((((((05 / 10)%R * t)%R * (3%R - ((t * t)%R * x_0)%R)%R)%R - (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R / (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R = ((-((15 / 10)%R + ((05 / 10)%R * ((t - (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R / (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R)%R)%R)%R * (((t - (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R / (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R * ((t - (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R / (1%R / (Reals.R_sqrt.sqrt x_0))%R)%R)%R)%R).

Axiom pointer_addr_of_charP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (charP_of_pointer_address p))).

Parameter unsigned_charP_of_pointer_address: (Jessie_memory_model.pointer
  unit) -> (Jessie_memory_model.pointer unsigned_charP).

Axiom pointer_addr_of_unsigned_charP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (unsigned_charP_of_pointer_address p))).

Parameter voidP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer voidP).

Axiom pointer_addr_of_voidP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (voidP_of_pointer_address p))).

(* Why3 assumption *)
Definition right_valid_struct_charP (p:(Jessie_memory_model.pointer charP))
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition right_valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  (b <= (Jessie_memory_model.offset_max unsigned_charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition right_valid_struct_voidP (p:(Jessie_memory_model.pointer voidP))
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

(* Why3 assumption *)
Definition strict_valid_root_charP (p:(Jessie_memory_model.pointer charP))
  (a:Z) (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table
  charP)): Prop := ((Jessie_memory_model.offset_min charP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_root_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) = a) /\
  ((Jessie_memory_model.offset_max unsigned_charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_root_voidP (p:(Jessie_memory_model.pointer voidP))
  (a:Z) (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table
  voidP)): Prop := ((Jessie_memory_model.offset_min voidP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max voidP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_charP (p:(Jessie_memory_model.pointer charP))
  (a:Z) (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table
  charP)): Prop := ((Jessie_memory_model.offset_min charP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) = a) /\
  ((Jessie_memory_model.offset_max unsigned_charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_voidP (p:(Jessie_memory_model.pointer voidP))
  (a:Z) (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table
  voidP)): Prop := ((Jessie_memory_model.offset_min voidP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max voidP_alloc_table p) = b).

Parameter uint8_of_integer: Z -> uint8.

Axiom uint8_coerce : forall (x:Z), ((0%Z <= x)%Z /\ (x <= 255%Z)%Z) ->
  ((integer_of_uint8 (uint8_of_integer x)) = x).

Axiom uint8_extensionality : forall (x:uint8), forall (y:uint8),
  ((integer_of_uint8 x) = (integer_of_uint8 y)) -> (x = y).

Axiom uint8_range : forall (x:uint8), (0%Z <= (integer_of_uint8 x))%Z /\
  ((integer_of_uint8 x) <= 255%Z)%Z.

Parameter unsigned_charP_tag: (Jessie_memory_model.tag_id unsigned_charP).

Axiom unsigned_charP_int : ((Jessie_memory_model.int_of_tag unsigned_charP_tag) = 1%Z).

Axiom unsigned_charP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  unsigned_charP)),
  (p = (unsigned_charP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom unsigned_charP_parenttag_bottom : (Jessie_memory_model.parenttag
  unsigned_charP_tag
  (Jessie_memory_model.bottom_tag : (Jessie_memory_model.tag_id
  unsigned_charP))).

Axiom unsigned_charP_tags : forall (x:(Jessie_memory_model.pointer
  unsigned_charP)),
  forall (unsigned_charP_tag_table:(Jessie_memory_model.tag_table
  unsigned_charP)), (Jessie_memory_model.instanceof unsigned_charP_tag_table
  x unsigned_charP_tag).

(* Why3 assumption *)
Definition valid_root_charP (p:(Jessie_memory_model.pointer charP)) (a:Z)
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_root_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max unsigned_charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_root_voidP (p:(Jessie_memory_model.pointer voidP)) (a:Z)
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_charP (p:(Jessie_memory_model.pointer charP)) (a:Z)
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_unsigned_charP (p:(Jessie_memory_model.pointer
  unsigned_charP)) (a:Z) (b:Z)
  (unsigned_charP_alloc_table:(Jessie_memory_model.alloc_table
  unsigned_charP)): Prop :=
  ((Jessie_memory_model.offset_min unsigned_charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max unsigned_charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_voidP (p:(Jessie_memory_model.pointer voidP)) (a:Z)
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

Parameter voidP_tag: (Jessie_memory_model.tag_id voidP).

Axiom voidP_int : ((Jessie_memory_model.int_of_tag voidP_tag) = 1%Z).

Axiom voidP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  voidP)),
  (p = (voidP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom voidP_parenttag_bottom : (Jessie_memory_model.parenttag voidP_tag
  (Jessie_memory_model.bottom_tag : (Jessie_memory_model.tag_id voidP))).

Axiom voidP_tags : forall (x:(Jessie_memory_model.pointer voidP)),
  forall (voidP_tag_table:(Jessie_memory_model.tag_table voidP)),
  (Jessie_memory_model.instanceof voidP_tag_table x voidP_tag).

Axiom newton : forall (t_0:R), forall (x_0_1:R), (0%R < x_0_1)%R ->
  (newton_rel t_0 x_0_1).

(* Why3 assumption *)
Inductive ref (a:Type) :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Definition single_of_double_post (m:floating_point.Rounding.mode)
  (x:floating_point.DoubleFormat.double)
  (res:floating_point.SingleFormat.single): Prop :=
  ((floating_point.Single.value res) = (floating_point.Single.round m
  (floating_point.Double.value x))) /\
  (((floating_point.Single.exact res) = (floating_point.Double.exact x)) /\
  ((floating_point.Single.model res) = (floating_point.Double.model x))).

(* Why3 assumption *)
Definition double_of_single_post (x:floating_point.SingleFormat.single)
  (res:floating_point.DoubleFormat.double): Prop :=
  ((floating_point.Double.value res) = (floating_point.Single.value x)) /\
  (((floating_point.Double.exact res) = (floating_point.Single.exact x)) /\
  ((floating_point.Double.model res) = (floating_point.Single.model x))).

(* Why3 goal *)
Theorem WP_parameter_sqrt_ensures_default : forall (x_2:floating_point.DoubleFormat.double),
  (((05 / 10)%R <= (floating_point.Double.value x_2))%R /\
  ((floating_point.Double.value x_2) <= 2%R)%R) ->
  forall (o:floating_point.DoubleFormat.double),
  ((Reals.Rbasic_fun.Rabs ((floating_point.Double.value o) - (1%R / (Reals.R_sqrt.sqrt (floating_point.Double.value x_2)))%R)%R) <= ((1 / 64)%R * (Reals.Rbasic_fun.Rabs (1%R / (Reals.R_sqrt.sqrt (floating_point.Double.value x_2)))%R))%R)%R ->
  forall (t_2:floating_point.DoubleFormat.double), (t_2 = o) ->
  forall (o1:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  t_2 t_2 o1) -> forall (o2:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o1 x_2 o2) -> forall (o3:floating_point.DoubleFormat.double),
  (((floating_point.Double.value o3) = 3%R) /\
  (((floating_point.Double.exact o3) = 3%R) /\
  ((floating_point.Double.model o3) = 3%R))) ->
  forall (o4:floating_point.DoubleFormat.double),
  (floating_point.Double.sub_post floating_point.Rounding.NearestTiesToEven
  o3 o2 o4) -> forall (o5:floating_point.DoubleFormat.double),
  (((floating_point.Double.value o5) = (05 / 10)%R) /\
  (((floating_point.Double.exact o5) = (05 / 10)%R) /\
  ((floating_point.Double.model o5) = (05 / 10)%R))) ->
  forall (o6:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o5 t_2 o6) -> forall (o7:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o6 o4 o7) -> forall (u_0:floating_point.DoubleFormat.double), (u_0 = o7) ->
  ((newton_rel (floating_point.Double.value t_2)
  (floating_point.Double.value x_2)) -> ((closeness
  (floating_point.Double.value u_0) (floating_point.Double.value t_2)
  (floating_point.Double.value x_2)) ->
  forall (t_21:floating_point.DoubleFormat.double), (t_21 = u_0) ->
  forall (o8:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  t_21 t_21 o8) -> forall (o9:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o8 x_2 o9) -> forall (o10:floating_point.DoubleFormat.double),
  (((floating_point.Double.value o10) = 3%R) /\
  (((floating_point.Double.exact o10) = 3%R) /\
  ((floating_point.Double.model o10) = 3%R))) ->
  forall (o11:floating_point.DoubleFormat.double),
  (floating_point.Double.sub_post floating_point.Rounding.NearestTiesToEven
  o10 o9 o11) -> forall (o12:floating_point.DoubleFormat.double),
  (((floating_point.Double.value o12) = (05 / 10)%R) /\
  (((floating_point.Double.exact o12) = (05 / 10)%R) /\
  ((floating_point.Double.model o12) = (05 / 10)%R))) ->
  forall (o13:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o12 t_21 o13) -> forall (o14:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o13 o11 o14) -> forall (u_01:floating_point.DoubleFormat.double),
  (u_01 = o14) -> ((newton_rel (floating_point.Double.value t_21)
  (floating_point.Double.value x_2)) -> ((closeness
  (floating_point.Double.value u_01) (floating_point.Double.value t_21)
  (floating_point.Double.value x_2)) ->
  forall (t_22:floating_point.DoubleFormat.double), (t_22 = u_01) ->
  forall (o15:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  t_22 t_22 o15) -> forall (o16:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o15 x_2 o16) -> forall (o17:floating_point.DoubleFormat.double),
  (((floating_point.Double.value o17) = 3%R) /\
  (((floating_point.Double.exact o17) = 3%R) /\
  ((floating_point.Double.model o17) = 3%R))) ->
  forall (o18:floating_point.DoubleFormat.double),
  (floating_point.Double.sub_post floating_point.Rounding.NearestTiesToEven
  o17 o16 o18) -> forall (o19:floating_point.DoubleFormat.double),
  (((floating_point.Double.value o19) = (05 / 10)%R) /\
  (((floating_point.Double.exact o19) = (05 / 10)%R) /\
  ((floating_point.Double.model o19) = (05 / 10)%R))) ->
  forall (o20:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o19 t_22 o20) -> forall (o21:floating_point.DoubleFormat.double),
  (floating_point.Double.mul_post floating_point.Rounding.NearestTiesToEven
  o20 o18 o21) -> forall (u_02:floating_point.DoubleFormat.double),
  (u_02 = o21) -> ((newton_rel (floating_point.Double.value t_22)
  (floating_point.Double.value x_2)) -> ((closeness
  (floating_point.Double.value u_02) (floating_point.Double.value t_22)
  (floating_point.Double.value x_2)) ->
  forall (t_23:floating_point.DoubleFormat.double), (t_23 = u_02) ->
  (((floating_point.Double.value x_2) * (1%R / (Reals.R_sqrt.sqrt (floating_point.Double.value x_2)))%R)%R = (Reals.R_sqrt.sqrt (floating_point.Double.value x_2))))))))).
(* Why3 intros x_2 (h1,h2) o h3 t_2 h4 o1 h5 o2 h6 o3 (h7,(h8,h9)) o4 h10 o5
        (h11,(h12,h13)) o6 h14 o7 h15 u_0 h16 h17 h18 t_21 h19 o8 h20 o9 h21
        o10 (h22,(h23,h24)) o11 h25 o12 (h26,(h27,h28)) o13 h29 o14 h30 u_01
        h31 h32 h33 t_22 h34 o15 h35 o16 h36 o17 (h37,(h38,h39)) o18 h40 o19
        (h41,(h42,h43)) o20 h44 o21 h45 u_02 h46 h47 h48 t_23 h49. *)
intros x. intros. clear -H.
assert (0 < Double.value x)%R.
apply Rlt_le_trans with (2 := proj1 H).
apply Fourier_util.Rlt_mult_inv_pos.
replace 5%R with (IZR 5) by (simpl ; ring).
now apply (IZR_lt 0 5).
replace 10%R with (IZR 10) by (simpl ; ring).
now apply (IZR_lt 0 10).
rewrite <- (R_sqrt.sqrt_def (Double.value x)) at 1.
field.
apply Rgt_not_eq.
now apply R_sqrt.sqrt_lt_R0.
now apply Rlt_le.
Qed.

