/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.ExpressionInput;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.Axes;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.DrawBorder;
import edu.hws.jcm.draw.Grid;
import edu.hws.jcm.draw.LimitControlPanel;
import edu.hws.jcm.draw.Panner;
import edu.hws.jcm.functions.ExpressionFunction;
import edu.hws.jcm.functions.SummationParser;
import edu.hws.jcm.functions.TableFunction;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class GenericGraphApplet
extends Applet
implements ActionListener,
ItemListener {
    protected Parser parser;
    protected JCMPanel mainPanel;
    protected Controller mainController;
    protected DisplayCanvas canvas;
    protected LimitControlPanel limitsPanel;
    protected ExpressionInput functionInput;
    protected Variable xVar;
    protected JCMPanel inputPanel;
    protected JCMPanel exampleMenuPanel;
    protected Button computeButton;
    protected String frameTitle;
    protected int[] defaultFrameSize = new int[]{550, 400};
    protected Hashtable parameterDefaults;
    private Choice exampleMenu;
    private Button loadExampleButton;
    private Button launchButton;
    private String launchButtonName;
    private Frame frame;
    private Vector exampleStrings;
    private String[] colorNames = new String[]{"black", "red", "blue", "green", "yellow", "cyan", "magenta", "gray", "darkgray", "lightgray", "pink", "orange", "white"};
    private Color[] colors = new Color[]{Color.black, Color.red, Color.blue, Color.green, Color.yellow, Color.cyan, Color.magenta, Color.gray, Color.darkGray, Color.lightGray, Color.pink, Color.orange, Color.white};

    @Override
    public void init() {
        int n;
        this.setUpParameterDefaults();
        this.frameTitle = this.getParameter("FrameTitle");
        if (this.frameTitle == null) {
            this.frameTitle = this.getClass().getName();
            n = this.frameTitle.lastIndexOf(46);
            if (n > -1) {
                this.frameTitle = this.frameTitle.substring(n + 1);
            }
        }
        this.setLayout(new BorderLayout());
        n = this.getSize().height;
        this.launchButtonName = this.getParameter("LaunchButtonName");
        if (n > 0 && n < 100 || this.launchButtonName != null) {
            if (this.launchButtonName == null) {
                this.launchButtonName = "Launch " + this.frameTitle;
            }
            this.launchButton = new Button(this.launchButtonName);
            this.add((Component)this.launchButton, "Center");
            this.launchButton.addActionListener(this);
        } else {
            this.mainPanel = new JCMPanel();
            try {
                this.setUpMainPanel();
                this.add((Component)this.mainPanel, "Center");
            }
            catch (Exception exception) {
                System.out.println("Error while opening applet:");
                exception.printStackTrace();
                TextArea textArea = new TextArea("An error occurred while setting up the applet:\n\n");
                textArea.append(exception.toString());
                this.add((Component)textArea, "Center");
            }
        }
    }

    protected void setUpMainPanel() {
        String string;
        this.parser = new Parser(null, 0);
        this.setUpParser();
        this.setUpExampleMenu();
        double[] dArray = this.getNumericParam("Insets");
        if (dArray == null || dArray.length == 0 || dArray[0] < 0.0 || dArray[0] > 50.0) {
            this.mainPanel.setInsetGap(3);
        } else {
            this.mainPanel.setInsetGap((int)Math.round(dArray[0]));
        }
        Color color = this.getColorParam("BackgroundColor", Color.gray);
        this.mainPanel.setBackground(color);
        color = this.getColorParam("ForegroundColor", Color.black);
        this.mainPanel.setForeground(color);
        this.canvas = new DisplayCanvas();
        double[] dArray2 = this.getNumericParam("Limits");
        if (dArray2 != null && dArray2.length >= 4) {
            this.canvas.getCoordinateRect().setLimits(dArray2);
        }
        if ("yes".equalsIgnoreCase(this.getParameter("UseLimitsPanel", "yes"))) {
            string = this.getParameter("XName");
            if (string == null) {
                string = this.getParameter("Variable", "x");
            }
            String string2 = this.getParameter("YName", "y");
            this.limitsPanel = new LimitControlPanel(string + "min", string + "max", string2 + "min", string2 + "max", 0, false);
        }
        this.mainController = this.mainPanel.getController();
        this.setUpBottomPanel();
        this.setUpTopPanel();
        this.setUpCanvas();
        this.addCanvasBorder();
        if (this.limitsPanel != null) {
            this.setUpLimitsPanel();
        }
        String string3 = string = this.loadExampleButton == null ? "yes" : "no";
        if (this.exampleStrings != null && this.exampleStrings.size() > 0 && !"no".equalsIgnoreCase(this.getParameter("LoadFirstExample", string))) {
            this.doLoadExample((String)this.exampleStrings.elementAt(0));
        }
    }

    protected void setUpCanvas() {
        Color color = this.getColorParam("CanvasColor");
        if (color != null) {
            this.canvas.setBackground(color);
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UsePanner", "no"))) {
            this.canvas.add(new Panner());
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UseGrid", "no"))) {
            Grid grid = new Grid();
            color = this.getColorParam("GridColor");
            if (color != null) {
                grid.setColor(color);
            }
            this.canvas.add(grid);
        }
        this.canvas.add(this.makeAxes());
        if (!"no".equalsIgnoreCase(this.getParameter("UseMouseZoom", "no"))) {
            this.canvas.setHandleMouseZooms(true);
        }
        if ("yes".equalsIgnoreCase(this.getParameter("UseOffscreenCanvas", "yes"))) {
            this.canvas.setUseOffscreenCanvas(true);
        }
        this.mainController.setErrorReporter(this.canvas);
        this.mainPanel.add((Component)this.canvas, "Center");
    }

    protected Axes makeAxes() {
        String string;
        Axes axes = new Axes();
        Color color = this.getColorParam("AxesColor");
        if (color != null) {
            axes.setAxesColor(color);
        }
        if ((color = this.getColorParam("AxesLightColor")) != null) {
            axes.setLightAxesColor(color);
        }
        if ((string = this.getParameter("XLabel")) != null) {
            axes.setXLabel(string);
        }
        string = this.getParameter("YLabel");
        axes.setYLabel(string);
        color = this.getColorParam("LabelColor");
        if (color != null) {
            axes.setLabelColor(color);
        }
        return axes;
    }

    protected void addCanvasBorder() {
        double[] dArray = this.getNumericParam("BorderWidth");
        int n = dArray == null || dArray.length == 0 || dArray[0] > 25.0 ? 2 : (int)Math.round(dArray[0]);
        if (n > 0) {
            this.canvas.add(new DrawBorder(this.getColorParam("BorderColor", Color.black), n));
        }
    }

    protected void setUpBottomPanel() {
        if ("yes".equalsIgnoreCase(this.getParameter("UseFunctionInput", "yes"))) {
            String string;
            String string2 = this.getParameter("Function");
            String string3 = this.xVar.getName();
            if (string2 == null) {
                string2 = "abs(" + string3 + " ) ^ " + string3;
            }
            this.functionInput = new ExpressionInput(string2, this.parser);
            this.inputPanel = new JCMPanel();
            this.inputPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
            this.inputPanel.add((Component)this.functionInput, "Center");
            if ("yes".equalsIgnoreCase(this.getParameter("UseComputeButton", "yes"))) {
                string = this.getParameter("ComputeButtonName", "New Function");
                this.computeButton = new Button(string);
                this.inputPanel.add((Component)this.computeButton, "East");
                this.computeButton.addActionListener(this);
            }
            if ((string = this.getParameter("FunctionLabel")) == null) {
                string = " f(" + string3 + ") = ";
            }
            if (!"none".equalsIgnoreCase(string)) {
                this.inputPanel.add((Component)new Label(string), "West");
            }
            this.mainPanel.add((Component)this.inputPanel, "South");
            this.functionInput.setOnUserAction(this.mainPanel.getController());
        }
    }

    protected void setUpLimitsPanel() {
        this.limitsPanel.addCoords(this.canvas);
        if (!"no".equalsIgnoreCase(this.getParameter("TwoLimitsColumns", "no"))) {
            this.limitsPanel.setUseTwoColumnsIfPossible(true);
        }
        int n = 0;
        if ("yes".equalsIgnoreCase(this.getParameter("UseSetLimitsButton", "yes"))) {
            n |= 1;
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UseZoomButtons", "no"))) {
            n |= 0xC;
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UseEqualizeButton", "no"))) {
            n |= 2;
        }
        if (!"no".equalsIgnoreCase(this.getParameter("UseRestoreButton", "no"))) {
            n |= 0x20;
        }
        if (n != 0) {
            this.limitsPanel.addButtons(n);
        }
        this.limitsPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
        if (!"yes".equalsIgnoreCase(this.getParameter("LimitsOnLeft", "no"))) {
            this.mainPanel.add((Component)this.limitsPanel, "East");
        } else {
            this.mainPanel.add((Component)this.limitsPanel, "West");
        }
        this.limitsPanel.setErrorReporter(this.canvas);
    }

    protected void setUpTopPanel() {
        if (this.exampleMenuPanel != null) {
            this.mainPanel.add((Component)this.exampleMenuPanel, "North");
        } else {
            String string = this.getParameter("PanelTitle");
            if (string != null) {
                Label label = new Label(string, 1);
                label.setForeground(this.getColorParam("TitleForeground", new Color(200, 0, 0)));
                label.setBackground(this.getColorParam("TitleBackground", Color.lightGray));
                label.setFont(new Font("Serif", 0, 14));
                this.mainPanel.add((Component)label, "North");
            }
        }
    }

    protected void setUpExampleMenu() {
        Component component;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        String string = "Example";
        String string2 = this.getParameter(string);
        if (string2 == null) {
            string = "Example" + ++n;
            string2 = this.getParameter(string);
        }
        while (string2 != null) {
            int n2 = string2.indexOf(59);
            if (n2 < 0) {
                vector.addElement(string2);
                vector2.addElement(string2);
            } else {
                vector.addElement(string2.substring(n2 + 1));
                vector2.addElement(string2.substring(0, n2));
            }
            string = "Example" + ++n;
            string2 = this.getParameter(string);
        }
        if (vector.size() == 0) {
            return;
        }
        this.exampleStrings = vector;
        this.exampleStrings.trimToSize();
        this.exampleMenuPanel = new JCMPanel();
        if ("yes".equalsIgnoreCase(this.getParameter("UseLoadButton", "yes"))) {
            this.loadExampleButton = new Button("Load Example: ");
            this.loadExampleButton.setBackground(Color.lightGray);
            this.loadExampleButton.addActionListener(this);
        }
        if (vector2.size() == 1) {
            component = new Label((String)vector2.elementAt(0), 1);
        } else {
            this.exampleMenu = new Choice();
            component = this.exampleMenu;
            for (int i = 0; i < vector2.size(); ++i) {
                this.exampleMenu.add((String)vector2.elementAt(i));
            }
            if (this.loadExampleButton == null) {
                this.exampleMenu.addItemListener(this);
            }
        }
        component.setBackground(Color.white);
        this.exampleMenuPanel.add(component, "Center");
        if (this.loadExampleButton != null) {
            this.exampleMenuPanel.add((Component)this.loadExampleButton, "West");
        }
    }

    protected void setUpParser() {
        String string;
        if ("yes".equalsIgnoreCase(this.getParameter("StandardFunctions", "yes"))) {
            this.parser.addOptions(1024);
        }
        if ("yes".equalsIgnoreCase(this.getParameter("Booleans", "yes"))) {
            this.parser.addOptions(32);
        }
        if (!"no".equalsIgnoreCase(this.getParameter("OptionalStars", "no"))) {
            this.parser.addOptions(2);
        }
        if (!"no".equalsIgnoreCase(this.getParameter("OptionalParens", "no"))) {
            this.parser.addOptions(512);
        }
        if (!"no".equalsIgnoreCase(this.getParameter("Factorials", "no"))) {
            this.parser.addOptions(64);
        }
        if ("yes".equalsIgnoreCase(this.getParameter("Summations", "yes"))) {
            this.parser.add(new SummationParser());
        }
        if ((string = this.getParameter("Define")) != null) {
            this.define(string);
        }
        int n = 1;
        while ((string = this.getParameter("Define" + n)) != null) {
            this.define(string);
            ++n;
        }
        this.xVar = new Variable(this.getParameter("Variable", "x"));
        this.parser.add(this.xVar);
    }

    protected void doLoadExample(String string) {
    }

    protected void setUpParameterDefaults() {
    }

    @Override
    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 == null && this.parameterDefaults != null) {
            string2 = (String)this.parameterDefaults.get(string);
        }
        return string2;
    }

    protected String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        return string3 == null ? string2 : string3;
    }

    protected double[] getNumericParam(String string) {
        return this.getNumericParam(string, null);
    }

    protected double[] getNumericParam(String string, double[] dArray) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return dArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,;");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            try {
                Double d = new Double(stringTokenizer.nextToken());
                dArray2[i] = d;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return dArray;
            }
        }
        return dArray2;
    }

    protected Color getColorParam(String string) {
        return this.getColorParam(string, null);
    }

    protected Color getColorParam(String string, Color color) {
        String string2 = this.getParameter(string);
        if (string2 == null || string2.trim().length() == 0) {
            return color;
        }
        if (Character.isLetter((string2 = string2.trim()).charAt(0))) {
            for (int i = 0; i < this.colorNames.length; ++i) {
                if (!string2.equalsIgnoreCase(this.colorNames[i])) continue;
                return this.colors[i];
            }
            return color;
        }
        double[] dArray = this.getNumericParam(string, null);
        if (dArray == null || dArray.length < 3) {
            return color;
        }
        if (dArray[0] < 0.0 || dArray[0] > 255.0 || dArray[1] < 0.0 || dArray[1] > 255.0 || dArray[2] < 0.0 || dArray[2] > 255.0) {
            return color;
        }
        return new Color((int)Math.round(dArray[0]), (int)Math.round(dArray[1]), (int)Math.round(dArray[2]));
    }

    @Override
    public void stop() {
        if (this.canvas != null && this.frame == null) {
            this.canvas.releaseResources();
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    private void define(String string) {
        String string2 = string;
        try {
            int n = string2.indexOf("=");
            if (n < 0) {
                throw new ParseError("Missing \"=\"", null);
            }
            String string3 = string2.substring(n + 1).trim();
            string2 = string2.substring(0, n);
            if (string3.toLowerCase().startsWith("table")) {
                String string4 = string2;
                n = string4.indexOf("(");
                if (n > 0) {
                    string4 = string4.substring(0, n).trim();
                }
                TableFunction tableFunction = this.parseTableFuncDef(string3);
                tableFunction.setName(string4);
                this.parser.add(tableFunction);
            } else {
                n = string2.indexOf("(");
                if (n < 0) {
                    throw new ParseError("Missing \"(\"", null);
                }
                String string5 = string2.substring(0, n).trim();
                if (string5.length() == 0) {
                    throw new ParseError("Missing function name", null);
                }
                if ((n = (string2 = string2.substring(n + 1)).indexOf(")")) < 0) {
                    throw new ParseError("Missing \")\"", null);
                }
                if ((string2 = string2.substring(0, n).trim()).length() == 0) {
                    throw new ParseError("Missing parameter names", null);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n2 = stringTokenizer.countTokens();
                String[] stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = stringTokenizer.nextToken();
                }
                new ExpressionFunction(string5, stringArray, string3, this.parser);
            }
        }
        catch (ParseError parseError) {
            throw new IllegalArgumentException("Error parsing function \"" + string + "\":" + parseError.getMessage());
        }
    }

    protected TableFunction parseTableFuncDef(String string) {
        try {
            int n;
            boolean bl;
            TableFunction tableFunction = new TableFunction();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t,");
            String string2 = null;
            if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).equalsIgnoreCase("table") && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if ("step".equalsIgnoreCase(string2)) {
                tableFunction.setStyle(2);
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
            } else if ("linear".equalsIgnoreCase(string2)) {
                tableFunction.setStyle(1);
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
            } else if ("smooth".equalsIgnoreCase(string2) && stringTokenizer.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if ((bl = "intervals".equalsIgnoreCase(string2)) && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            double[] dArray = new double[stringTokenizer.countTokens() + 1];
            try {
                dArray[0] = new Double(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseError("Unexpected token \"" + string2 + "\".", null);
            }
            try {
                for (n = 1; n < dArray.length; ++n) {
                    dArray[n] = new Double(stringTokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseError("Illegal number.", null);
            }
            if (bl) {
                double d;
                int n2 = n = dArray.length == 0 ? 6 : (int)Math.round(dArray[0]);
                if (n < 1 || n > 500) {
                    n = 6;
                }
                double d2 = dArray.length < 2 ? -5.0 : dArray[1];
                double d3 = d = dArray.length < 3 ? d2 + 10.0 : dArray[2];
                if (d <= d2) {
                    throw new ParseError("xmax in table must be greater than xmin", null);
                }
                tableFunction.addIntervals(n, d2, d);
                for (int i = 3; i < dArray.length && i - 3 <= n; ++i) {
                    if (i - 3 >= n) continue;
                    tableFunction.setY(i - 3, dArray[i]);
                }
            } else {
                if (dArray.length < 4) {
                    throw new ParseError("At least two points must be provided for table function.", null);
                }
                if (dArray.length % 2 == 1) {
                    throw new ParseError("Can't define an table function with an odd number of values.", null);
                }
                for (n = 0; n < dArray.length / 2; ++n) {
                    tableFunction.addPoint(dArray[2 * n], dArray[2 * n + 1]);
                }
            }
            return tableFunction;
        }
        catch (Exception exception) {
            throw new ParseError("Error while parsing table function: " + exception.getMessage(), null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.computeButton && this.computeButton != null) {
            this.mainController.compute();
        } else if (object == this.launchButton && this.launchButton != null) {
            this.doLaunchButton();
        } else if (object == this.loadExampleButton && this.exampleStrings != null) {
            if (this.exampleStrings.size() == 1) {
                this.doLoadExample((String)this.exampleStrings.elementAt(0));
            } else {
                this.doLoadExample((String)this.exampleStrings.elementAt(this.exampleMenu.getSelectedIndex()));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.exampleMenu) {
            this.doLoadExample((String)this.exampleStrings.elementAt(this.exampleMenu.getSelectedIndex()));
        }
    }

    private synchronized void doLaunchButton() {
        this.launchButton.setEnabled(false);
        if (this.frame == null) {
            this.frame = new Frame(this.frameTitle);
            this.mainPanel = new JCMPanel();
            try {
                this.setUpMainPanel();
                this.frame.add((Component)this.mainPanel, "Center");
            }
            catch (Throwable throwable) {
                System.out.println("Error while opening window:");
                throwable.printStackTrace();
                TextArea textArea = new TextArea("An error occurred while setting up this window:\n\n");
                textArea.append(throwable.toString());
                this.frame.add((Component)textArea, "Center");
            }
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    GenericGraphApplet.this.frame.dispose();
                }

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    GenericGraphApplet.this.frameClosed();
                }
            });
            double[] dArray = this.getNumericParam("FrameSize");
            if (dArray == null || dArray.length < 2 || dArray[0] < 100.0 || dArray[0] > 800.0 || dArray[1] < 100.0 || dArray[1] > 600.0) {
                this.frame.setSize(this.defaultFrameSize[0], this.defaultFrameSize[1]);
            } else {
                this.frame.setSize((int)Math.round(dArray[0]), (int)Math.round(dArray[1]));
            }
            this.frame.setLocation(50, 50);
            this.frame.show();
            this.launchButton.setLabel("Close Window");
            this.launchButton.setEnabled(true);
        } else {
            this.frame.dispose();
        }
    }

    private synchronized void frameClosed() {
        this.frame = null;
        this.launchButton.setLabel(this.launchButtonName);
        this.launchButton.setEnabled(true);
        this.mainPanel = null;
        this.canvas = null;
        this.limitsPanel = null;
        this.inputPanel = null;
        this.exampleMenuPanel = null;
        this.loadExampleButton = null;
        this.computeButton = null;
        this.parser = null;
    }
}

