#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import traceback

from winswitch.util.file_io import load_object_from_properties, save_object_to_properties, get_persist
from winswitch.util.simple_logger import set_loggers_debug


set_loggers_debug(True)

class TestReload:

	PERSIST = ["str", "int", "list"]

	def __init__(self):
		self.str = "hello"
		self.int = 1
		self.list  = ["l1", "l2", "l3"]

try:
	filename = "/tmp/props.txt"
	test = TestReload()
	test.str="modstr"
	test.int=2
	test.list = ["m1", "m2"]
	save_object_to_properties(filename, test)

	reloaded = load_object_from_properties(filename, TestReload)

	for field in get_persist(test):
		print "testing '%s'" % field
		original = getattr(test, field)
		new = getattr(reloaded, field)
		print "found original=%s, new=%s" % (original, new)

except Exception, e:
	print 'file_io_test Caught exception: %s: %s' % (e.__class__, e)
	traceback.print_exc()
