#ifndef _VECIMAGE_H_
#define _VECIMAGE_H_

#include "stringa.h"
#include "raster.h"


class CpTranslator;

typedef struct
	{
	float FontSize, FontSizeW;
	WORD FontWeight;
        CpTranslator *ConvertCpg;
        
	char FontItallic;
	char dirty;
	char FillPattern;
	BYTE LineStyle;

	float LineWidth;
	RGB_Record FillColor;
        BYTE FillTransparency;
        RGB_Record FillBackground;

	RGB_Record LineColor;
	RGB_Record TextColor;

        bool FirstTimeFix;
	} PS_State;


class AbstractTransformXY
{
public:
  virtual void ApplyTransform(float &x, float &y) const = 0;
};


/** This functor class is used for resizing image data. */
class vecResizeXY: public AbstractTransformXY
{
public:
  vecResizeXY(const float iniScale) {Scale=iniScale;}

  virtual void ApplyTransform(float &x, float &y) const {x*=Scale; y*=Scale;}

  float Scale;
};



///////////////////////////////////////////////////////////

class VectorAttribute
{
public:
  virtual ~VectorAttribute() {}
  virtual void prepExport(PS_State *PSS) const = 0;
};

class vecPen: public VectorAttribute
{
public:
  RGB_Record LineColor;
  unsigned char LineStyle;
  float PenWidth;

  vecPen(void);
  vecPen(const PS_State &PSS) {AttribFromPSS(PSS);}

  virtual void prepExport(PS_State *PSS) const;
  void AttribFromPSS(const PS_State &PSS);
};


class vecBrush: public VectorAttribute
{
public:
  RGB_Record FillColor;
  unsigned char BrushStyle;

  vecBrush() {BrushStyle=1;}
  vecBrush(const PS_State &PSS);

  virtual void prepExport(PS_State *PSS) const;
  void AttribFromPSS(const PS_State &PSS);
};


class vecFont: public VectorAttribute
{
public:
  vecFont();
  vecFont(const PS_State &PSS);
  virtual void prepExport(PS_State *PSS) const;

  CpTranslator *ConvertCpg;
  RGB_Record TextColor;
  float FontSize, FontSizeW;
  WORD Weight;
  char Italic;
};


class vecTransform
{
public:
  float CenterX, CenterY;
  float RotAngle;
  float TranslateX, TranslateY;
  float ScaleX, ScaleY;
 
  vecTransform(void);
  bool ApplyTransform(string &s);
};


///////////////////////////////////////////////////////////

/** Base Vector object. */
class VectorObject
{
public:
  virtual string Export2EPS(PS_State *PSS=NULL) const {return string();}
  virtual void Transform(const AbstractTransformXY &Tx) {}
  virtual ~VectorObject() {}
};


/** List of plain Vector objects. */
class VectorList: public VectorObject
{
public:
  virtual string Export2EPS(PS_State *PSS=NULL) const;
  VectorList(void);
  virtual ~VectorList();

  void AddObject(VectorObject *NewObj);
  virtual void Transform(const AbstractTransformXY &Tx);

  VectorObject **Objects;
  int VectorObjects;
};


class VectorEllipse: public VectorObject, public vecPen, public vecBrush
{
public:
  VectorEllipse(float iniBottomRect, float iniTopRect, float iniRightRect, float iniLeftRect);
  virtual ~VectorEllipse();

  virtual string Export2EPS(PS_State *PSS=NULL) const;
  virtual void Transform(const AbstractTransformXY &Tx);
  void AttribFromPSS(const PS_State &PSS) {vecPen::AttribFromPSS(PSS);vecBrush::AttribFromPSS(PSS);}

  vecTransform *Tx;
  int bAngle, eAngle;
  float	BottomRect, TopRect, RightRect, LeftRect;
};


class VectorLine: public VectorObject, public vecPen
{
public:
  VectorLine(float *iniBottomRect, int iniPointCount);
  virtual ~VectorLine();

  virtual string Export2EPS(PS_State *PSS=NULL) const;
  virtual void Transform(const AbstractTransformXY &Tx);

  int CountPoints;
  float *Points;  	///< x, y coordinate list of the line.
  bool Close;
};


class VectorPolygon: public VectorObject, public vecPen, public vecBrush
{
public:
  VectorPolygon(float *iniBottomRect, int iniPointCount);
  virtual ~VectorPolygon();

  virtual string Export2EPS(PS_State *PSS=NULL) const;
  virtual void Transform(const AbstractTransformXY &Tx);
  void AttribFromPSS(const PS_State &PSS) {vecPen::AttribFromPSS(PSS);vecBrush::AttribFromPSS(PSS);}

  int CountPoints;
  float *Points;  
  bool Close;
  bool Outline;  
};


class VectorRectangle: public VectorObject, public vecPen, public vecBrush
{
public:
  VectorRectangle(float iniBottomRect, float iniTopRect, float iniRightRect, float iniLeftRect);
  ~VectorRectangle();

  virtual string Export2EPS(PS_State *PSS=NULL) const;
  virtual void Transform(const AbstractTransformXY &Tx);
  void AttribFromPSS(const PS_State &PSS) {vecPen::AttribFromPSS(PSS);vecBrush::AttribFromPSS(PSS);}

  vecTransform *Tx;
  float	BottomRect, TopRect, RightRect, LeftRect;
};


class VectorRectangleArc: public VectorRectangle
{
public:
  VectorRectangleArc(float iniBottomRect, float iniTopRect, float iniRightRect, float iniLeftRect, 
                     float iniHradius, float iniVradius);

  virtual string Export2EPS(PS_State *PSS=NULL) const;
  virtual void Transform(const AbstractTransformXY &Tx);

  float	Hradius, Vradius;
};


/** Container for text, must be included into ::TextContainer. */
class TextObject
{
public:
  string TargetFont;
  string contents;
  //WORD Weight;
  //char Itallic;
  float size;
};


class TextContainer: public VectorObject
{
public:
  float PosX, PosY;

  TextContainer();
  virtual ~TextContainer();  

  virtual string Export2EPS(PS_State *PSS=NULL) const;
  virtual void Transform(const AbstractTransformXY &Tx);
  
  void AddText(temp_string contents, const PS_State &PSS);
  void AddText(temp_string contents, const char *font, const PS_State &PSS);

  bool isEmpty(void) const;

  TextObject **Text;
  int TextObjects;

  RGB_Record TextColor;  
};

#endif
