;;; hebrew.el --- Quail package for inputting Hebrew characters  -*-coding: iso-8859-8 -*-

;; Copyright (C) 1999
;;   National Institute of Advanced Industrial Science and Technology (AIST)
;;   Registration Number H14PRO021

;; Keywords: mule, input method, Hebrew

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Synched up with: FSF 22.0.50.6

;;; Commentary:

;;; XEmacs change; encode the file as ISO-8859-8, which is compatible
;;; with 21.4. 

;;; Code:

(require 'quail)

(quail-define-package
 "hebrew" "Hebrew" "" nil "Hebrew (ISO 8859-8) input method.

Based on Hebrew typewriter keys.
Hebrew letters are assigned to lowercases.
" nil t t t t nil nil nil nil nil t)

;;  1! 2@ 3# 4$ 5% 6^ 7& 8* 9( 0) -_ =+ ;~
;;   /Q 'W E R T Y U I O P [{ ]}
;;    A S D F G H J K L : ," \|
;;     Z X C V B N M < > .?
;;

(quail-define-rules
 ("`" ?\;)
 ("q" ?/)
 ("w" ?')
 ("e" ?)
 ("r" ?)
 ("t" ?)
 ("y" ?)
 ("u" ?)
 ("i" ?)
 ("o" ?)
 ("p" ?)
 ("a" ?)
 ("s" ?)
 ("d" ?)
 ("f" ?)
 ("g" ?)
 ("h" ?)
 ("j" ?)
 ("k" ?)
 ("l" ?)
 (";" ?)
 ("z" ?)
 ("x" ?)
 ("c" ?)
 ("v" ?)
 ("b" ?)
 ("n" ?)
 ("m" ?)
 ("," ?)
 ("." ?)
 ("/" ?.)
 ("'" ?,))

;;; arch-tag: 771b887d-15af-4a4d-b4ce-a4a86f5ca0cf
;;; hebrew.el ends here
