#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <xs.h>

#include "apps.h"

/* ------------------------------------------------------------------ */

#if 0
/* check_wm_capability(dpy, root, _NET_SUPPORTED, _NET_WM_whatever); */
static int
check_wm_capability(Display *dpy, Window root, Atom list, Atom wanted)
{
    Atom            type;
    int             format;
    unsigned int    i;
    unsigned long   nitems, bytesafter;
    unsigned char   *args;
    unsigned long   *ldata;
    char            *name;
    int             retval = -1;
    
    if (Success != XGetWindowProperty
	(dpy, root, list, 0, (65536 / sizeof(long)), False,
	 AnyPropertyType, &type, &format, &nitems, &bytesafter, &args))
	return -1;
    if (type != XA_ATOM)
	return -1;
    ldata = (unsigned long*)args;
    for (i = 0; i < nitems; i++) {
	if (ldata[i] == wanted)
	    retval = 0;
	if (debug) {
	    name = XGetAtomName(dpy,ldata[i]);
	    fprintf(stderr,"wm cap: %s\n",name);
	    XFree(name);
	}
    }
    XFree(ldata);
    return retval;
}
#endif

static int
check_atom_present(Display *dpy, Window root, Atom check)
{
    Atom            type;
    int             format;
    unsigned long   nitems, bytesafter;
    unsigned char   *args;
    
    if (Success != XGetWindowProperty
	(dpy, root, check, 0, (65536 / sizeof(long)), False,
	 AnyPropertyType, &type, &format, &nitems, &bytesafter, &args))
	return -1;
    if (NULL == args)
	return -1;
    return 0;
}

#define INIT_ATOM(dpy,atom) atom = XInternAtom(dpy,#atom,False)
static Atom KWIN_RUNNING;
static Atom _METACITY_SENTINEL;

void detect_desktop(void)
{
    Display *dpy = gdk_x11_display_get_xdisplay(gdk_display_get_default());
    Window  root = DefaultRootWindow(dpy);

    INIT_ATOM(dpy, KWIN_RUNNING);
    INIT_ATOM(dpy, _METACITY_SENTINEL);

    if (0 == check_atom_present(dpy, root, KWIN_RUNNING)) {
	fprintf(stderr,"Desktop: KDE\n");
	desktop_type = DESKTOP_KDE;
    }
    if (0 == check_atom_present(dpy, root, _METACITY_SENTINEL)) {
	fprintf(stderr,"Desktop: Gnome\n");
	desktop_type = DESKTOP_GNOME;
    }
}
