/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.expr.StaticProperty;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;

public final class SequenceType
implements Serializable {
    private ItemType primaryType;
    private int cardinality;
    private static Map pool = Collections.synchronizedMap(new HashMap(50));
    public static final SequenceType ANY_SEQUENCE = SequenceType.makeSequenceType(AnyItemType.getInstance(), 57344);
    public static final SequenceType SINGLE_ITEM = SequenceType.makeSequenceType(AnyItemType.getInstance(), 16384);
    public static final SequenceType SINGLE_ATOMIC = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 16384);
    public static final SequenceType OPTIONAL_ATOMIC = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 24576);
    public static final SequenceType ATOMIC_SEQUENCE = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344);
    public static final SequenceType SINGLE_STRING = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, 16384);
    public static final SequenceType SINGLE_INTEGER = SequenceType.makeSequenceType(BuiltInAtomicType.INTEGER, 16384);
    public static final SequenceType SINGLE_DOUBLE = SequenceType.makeSequenceType(BuiltInAtomicType.DOUBLE, 16384);
    public static final SequenceType OPTIONAL_INTEGER = SequenceType.makeSequenceType(BuiltInAtomicType.INTEGER, 24576);
    public static final SequenceType OPTIONAL_NUMERIC = SequenceType.makeSequenceType(BuiltInAtomicType.NUMERIC, 24576);
    public static final SequenceType OPTIONAL_NODE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 24576);
    public static final SequenceType SINGLE_NODE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 16384);
    public static final SequenceType NODE_SEQUENCE = SequenceType.makeSequenceType(AnyNodeTest.getInstance(), 57344);
    public static final SequenceType NUMERIC_SEQUENCE = SequenceType.makeSequenceType(BuiltInAtomicType.NUMERIC, 57344);
    public static final SequenceType EMPTY_SEQUENCE = SequenceType.makeSequenceType(EmptySequenceTest.getInstance(), 8192);

    private SequenceType(ItemType primaryType, int cardinality) {
        this.primaryType = primaryType;
        this.cardinality = primaryType instanceof EmptySequenceTest ? 8192 : cardinality;
    }

    public static SequenceType makeSequenceType(ItemType primaryType, int cardinality) {
        int code;
        if (!(primaryType instanceof BuiltInAtomicType)) {
            return new SequenceType(primaryType, cardinality);
        }
        SequenceType[] array = (SequenceType[])pool.get(primaryType);
        if (array == null) {
            array = new SequenceType[8];
            pool.put(primaryType, array);
        }
        if (array[code = StaticProperty.getCardinalityCode(cardinality)] == null) {
            SequenceType s;
            array[code] = s = new SequenceType(primaryType, cardinality);
            return s;
        }
        return array[code];
    }

    public ItemType getPrimaryType() {
        return this.primaryType;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String toString() {
        String s = this.primaryType.toString();
        if (this.cardinality == 49152) {
            s = s + '+';
        } else if (this.cardinality == 57344) {
            s = s + '*';
        } else if (this.cardinality == 24576) {
            s = s + '?';
        }
        return s;
    }

    public int hashCode() {
        return this.primaryType.hashCode() ^ this.cardinality;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SequenceType) {
            return this.primaryType.equals(((SequenceType)obj).primaryType) && this.cardinality == ((SequenceType)obj).cardinality;
        }
        return false;
    }
}

