# **********************************************************************
#
# Copyright (c) 2003-2011 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

top_srcdir	= ..\..

PKG		= IcePatch2
LIBNAME		= $(PKG).dll
TARGETS		= $(bindir)\$(LIBNAME)
POLICY_TARGET   = $(POLICY).dll

SRCS		= AssemblyInfo.cs

GEN_SRCS	= $(GDIR)\FileInfo.cs \
		  $(GDIR)\FileServer.cs

SDIR		= $(slicedir)\IcePatch2
GDIR		= generated

!include $(top_srcdir)\config\Make.rules.mak.cs

MCSFLAGS	= $(MCSFLAGS) -target:library -out:$(TARGETS)
MCSFLAGS	= $(MCSFLAGS) -keyfile:$(KEYFILE)
MCSFLAGS	= $(MCSFLAGS) /doc:$(bindir)\$(PKG).xml /nowarn:1591

SLICE2CSFLAGS	= $(SLICE2CSFLAGS) -I$(slicedir) --ice

$(TARGETS):: $(SRCS) $(GEN_SRCS)
	$(MCS) /baseaddress:0x23000000 $(MCSFLAGS) -r:$(refdir)\Ice.dll $(SRCS) $(GEN_SRCS)

!if "$(DEBUG)" == "yes"
clean::
	del /q $(bindir)\$(PKG).pdb
!endif

clean::
	del /q $(bindir)\$(PKG).xml

install:: all
	copy $(bindir)\$(LIBNAME) "$(install_bindir)"
	copy $(bindir)\$(PKG).xml "$(install_bindir)"
!if "$(generate_policies)" == "yes"
	copy $(bindir)\$(POLICY) "$(install_bindir)"
	copy $(bindir)\$(POLICY_TARGET) "$(install_bindir)"
!endif
!if "$(DEBUG)" == "yes"
	copy $(bindir)\$(PKG).pdb "$(install_bindir)"
!endif

!include .depend.mak
